#ifndef _DIALOGS_TABSCHED_CPP
#define _DIALOGS_TABSCHED_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/TabSched.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSchedDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND TimeWindowBegin_hWnd     = NULL;
    static HWND TimeWindowEnd_hWnd       = NULL;

	//static HWND ConnectInterval_hWnd = NULL;
    //static HWND ServerAddress_hWnd   = NULL;
    //static HWND ServerPort_hWnd      = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        TimeWindowBegin_hWnd     = GetDlgItem(xHandle, ID_TIMEWINDBEGIN);
        TimeWindowEnd_hWnd       = GetDlgItem(xHandle, ID_TIMEWINDEND);

        //ConnectInterval_hWnd = GetDlgItem(xHandle, IDC_CONNECTINTERVAL);
        //ServerAddress_hWnd   = GetDlgItem(xHandle, IDC_SERVERADDRESS);
        //ServerPort_hWnd      = GetDlgItem(xHandle, IDC_SERVERPORT);

        //Set_Text(CompanyName_hWnd, gsCompanyName);
        //Set_Text(CompanyPwd_hWnd, gsCompanyPassword);

        //Set_Long(ConnectInterval_hWnd, gdwConnectInterval);
        //Set_Text(ServerAddress_hWnd, gsServerAddress);
        //Set_Long(ServerPort_hWnd, giServerPort);

		SYSTEMTIME MyST;

		GetLocalTime(&MyST);

		LongToTime(gdwStartTime, (int *)&MyST.wHour, (int *)&MyST.wMinute, (int *)&MyST.wSecond);
    	SendMessage(TimeWindowBegin_hWnd, MCM_SETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &MyST);

		LongToTime(gdwStopTime, (int *)&MyST.wHour, (int *)&MyST.wMinute, (int *)&MyST.wSecond);
		SendMessage(TimeWindowEnd_hWnd, MCM_SETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &MyST);

    		//gTempBSS.TimeWindowStart = TimeToLong(ST.wHour, ST.wMinute,  ST.wSecond);
            //ErrorMessage(xHandle, LongChar(gTempBSS.TimeWindowStart));
		//gdwStartTime = TimeToLong(9, 0, 0);
		//gdwStopTime = TimeToLong(17, 0, 0);



        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            MsgBox("Scheduling dialog not implemented.");

			SYSTEMTIME MyST;

			GetLocalTime(&MyST);

    		SendMessage(TimeWindowBegin_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &MyST);
			gdwStartTime = TimeToLong(MyST.wHour, MyST.wMinute, MyST.wSecond);

    		SendMessage(TimeWindowEnd_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &MyST);
			gdwStopTime = TimeToLong(MyST.wHour, MyST.wMinute, MyST.wSecond);

			/*
			char lsCompanyName[64 + 1];
            int liCompanyNameLen = Get_TextEx(CompanyName_hWnd, lsCompanyName, 64);
            if(liCompanyNameLen == 0 || liCompanyNameLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company name. Between 1 and 64 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsCompanyPwd[64 + 1];
            int liCompanyPwdLen = Get_TextEx(CompanyPwd_hWnd, lsCompanyPwd, 64);
            if(liCompanyPwdLen == 0 || liCompanyPwdLen > 64)
            {
                MessageBox(xHandle, "You must enter a valid company password. Between 1 and 64 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            DWORD ldwConnectInterval = Get_Long(ConnectInterval_hWnd);
            if(ldwConnectInterval < 5 || ldwConnectInterval > 86400)
            {
                MessageBox(xHandle, "You must enter a valid connection interval. Between 5 and 86,400.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsServerAddress[255 + 1];
            int liServerAddressLen = Get_TextEx(ServerAddress_hWnd, lsServerAddress, 255);
            if(liServerAddressLen == 0 || liServerAddressLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid server address. Between 1 and 255 characters.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            int liServerPort = Get_Long(ServerPort_hWnd);
            if(liServerPort == 0 || liServerPort > 65535)
            {
                MessageBox(xHandle, "You must enter a valid server port. Between 1 and 65,535.", gsTitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy(gsCompanyName, lsCompanyName);
            strcpy(gsCompanyPassword, lsCompanyPwd);
            strcpy(gsServerAddress, lsServerAddress);

            giServerPort       = liServerPort;
            gdwConnectInterval = ldwConnectInterval;
*/
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
